/********************** Copyright(c)***************************
** Shenzhen Yuejiang Technology Co., Ltd.
**
** http:// www.dobot.cc
**
**------File Info----------------------------------------------
** File name:            LinePatrol.h
** Latest modified date: 2019-05-17
** Latest version:       V1.0.0
** Description:          AIStarter LinePatrol
**
**------------------------------------------------------------
** Created by:
** Created date:         2019-05-17
** Version:              V1.0.0
** Descriptions:         AIStarter LinePatrol
**
**------------------------------------------------------------
** Modified by:
** Modified date:
** Version:
** Description:
**
*************************************************************/
#ifndef LinePatrol_H
#define LinePatrol_H

#include "Arduino.h"
#define IRMODULBENUM 6      /* Ѳߴ */
#define LINEPATROLTARGET 0  /* ĬѲߵĿλ */

#ifndef __DEBUG
#define __DEBUG             /* Զ */
#endif

class LINEPATROL
{
public:
    struct Offect                       /* ƫ */
    {
        float iRModule[IRMODULBENUM];   /* Ѳߴƫ */
        float maxOffect;                /* ƫ */
    };
    typedef struct Offect OFFECT; 
    typedef OFFECT *POFFECT; 

    struct Pid                  /* pid */
    {
        float kP;       
        float kI;
        float iValueLimit;      /* kIֵ */
        float kD;
    };
    typedef struct Pid PID;
    typedef PID *PPID;

    struct PIDCalculation       /* PID̲ */
    {
        float bias;         
        float lastBias;
        float location;
        float lastSpeed;
        float target;
        float pIDLocation;
        float ivalue;
    };
    typedef struct PIDCalculation PIDCALCULATION;
    typedef PIDCALCULATION *PPIDCALCULATION;

    void SetLocationPID(float kP,       
        float kI,
        float kILimit,
        float kD);
    void SetLocationDeviation( int iRModule1,
                               int iRModule2,
                               int iRModule3,
                               int iRModule4,
                               int iRModule5,
                               int iRModule6);
    float GetLocation(void);
    int GetIRModuleSetNum(void);
    float GetPIDLocation(void);
    int LocationPID(PIDCALCULATION *pIDParams, PID pID);
    void LinePatrolRun(float location, float speed, float maxOffectSpeed);
private:

};



#endif





