/********************** Copyright(c)***************************
** Shenzhen Yuejiang Technology Co., Ltd.
**
** http:// www.dobot.cc
**
**------File Info----------------------------------------------
** File name:            LinePatrol.cpp
** Latest modified date: 2019-05-17
** Latest version:       V1.0.0
** Description:          AIStarter LinePatrol
**
**------------------------------------------------------------
** Created by:      
** Created date:         2019-05-17
** Version:              V1.0.0
** Descriptions:         AIStarter LinePatrol
**
**------------------------------------------------------------
** Modified by:
** Modified date:
** Version:
** Description:
**
*************************************************************/
#include <LinePatrol.h>
#include <AIStarter.h>

LINEPATROL::PID gPID;
LINEPATROL::OFFECT gOffect;
LINEPATROL::PIDCALCULATION gPIDCalculation;

/*************************************************************
** Function name:       GetIRModuleSetNum
** Descriptions:        ȡѲߴλ
** Input parameters:    no
** Output parameters:   no
** Returned value:      شλ
*************************************************************/

int LINEPATROL::GetIRModuleSetNum(void)
{
    int Num = 0;
    for (int cir = 0; cir < IRMODULBENUM; cir++)
    {
        if (AIStarter_SmartBotGetIRModuleValue(cir) == 1)
        {
            Num++;
        }
    }
    return Num;
}


/*************************************************************
** Function name:       SetLocationDeviation
** Descriptions:        ôƫ
** Input parameters:    int iRModule1,  Ӧƫ
**                      int iRModule2,
**                      int iRModule3,
**                      int iRModule4,
**                      int iRModule5,
**                      int iRModule6
** Output parameters:   no
** Returned value:      no
*************************************************************/

void LINEPATROL::SetLocationDeviation( int iRModule1,
                                       int iRModule2,
                                       int iRModule3,
                                       int iRModule4,
                                       int iRModule5,
                                       int iRModule6)
{
    gOffect.iRModule[0] = iRModule1;
    gOffect.iRModule[1] = iRModule2;
    gOffect.iRModule[2] = iRModule3;
    gOffect.iRModule[3] = iRModule4;
    gOffect.iRModule[4] = iRModule5;
    gOffect.iRModule[5] = iRModule6;
    gOffect.maxOffect = 0;
    for (int i = 0; i < IRMODULBENUM; i++)
    {
        if ((fabs(gOffect.iRModule[i]) - LINEPATROLTARGET) > gOffect.maxOffect)
        {
            gOffect.maxOffect = gOffect.iRModule[i];
        }
    }
}

/*************************************************************
** Function name:       GetLocation
** Descriptions:        ȡƫ
** Input parameters:    no
** Output parameters:   no
** Returned value:      ƫ
*************************************************************/

float LINEPATROL::GetLocation(void)
{
    float location = 0;
    static float lastLocation = 0;
    int num = 0;
    for (int i = 0; i < IRMODULBENUM; i++)
    {
        if (AIStarter_SmartBotGetIRModuleValue(i) == 1)
        {
            location = location + gOffect.iRModule[i];
            num++;
        }
        
    }
    if (num != 0)
    {
        location = location / num;
    }
    else
    {
        location = lastLocation;
    }
    lastLocation = location;
    return location;
}

/*************************************************************
** Function name:       LocationPID
** Descriptions:        λPID
** Input parameters:    *PIDCalculation: PIDָ̲
**                      pID: PID
** Output parameters:   no
** Returned value:      λ
*************************************************************/

int LINEPATROL::LocationPID(PIDCALCULATION *PIDCalculation, PID pID)
{
    int pivalue = 0;
    PIDCalculation->bias = (PIDCalculation->location - PIDCalculation->target);
    PIDCalculation->ivalue -= PIDCalculation->bias;
    pivalue = pID.kI * PIDCalculation->ivalue;
    if (pivalue > pID.iValueLimit)
    {
        pivalue = pID.iValueLimit;
    }
    else if (pivalue < -pID.iValueLimit)
    {
        pivalue = -pID.iValueLimit;
    }

    PIDCalculation->pIDLocation = pID.kP * PIDCalculation->bias 
                        + pivalue
                        + pID.kD * (PIDCalculation->bias - PIDCalculation->lastBias);
    PIDCalculation->lastBias = PIDCalculation->bias;
    return PIDCalculation->pIDLocation;
}

/*************************************************************
** Function name:       SetLocationPID
** Descriptions:        PID
** Input parameters:    kP: 
**                      kI:
**                      kD:
**                      iValueLimit: kIֵ
** Output parameters:   no
** Returned value:      no
*************************************************************/

void LINEPATROL::SetLocationPID(float kP,
                                float kI,
                                float kD,
                                float iValueLimit)
{
    gPID.kP = kP;
    gPID.kI = kI;
    gPID.iValueLimit = iValueLimit;
    gPID.kD = kD;
}

/*************************************************************
** Function name:       GetPIDLocation
** Descriptions:        ȡPIDλ
** Input parameters:    no
** Output parameters:   no
** Returned value:      λ
*************************************************************/

float LINEPATROL::GetPIDLocation(void)
{
    gPIDCalculation.location = GetLocation();
#ifdef __DEBUG
    Serial.print("location: ");
    Serial.println(gPIDCalculation.location);
#endif __DEBUG
    gPIDCalculation.target = LINEPATROLTARGET;
    return LocationPID(&gPIDCalculation, gPID);
}

/*************************************************************
** Function name:       LinePatrolRun
** Descriptions:        ʼѲ
** Input parameters:    location: λ
**                      speed: ٶ
**                      maxOffectSpeed: ƫλõŷٶ
** Output parameters:   no
** Returned value:      no
*************************************************************/

void LINEPATROL::LinePatrolRun(float location, 
                               float speed, 
                               float maxOffectSpeed)
{
#ifdef __DEBUG
    Serial.print("LinePatrollocation: ");
    Serial.println(location);
#endif __DEBUG
    int speedSlow = 0;			
    if (gOffect.maxOffect != 0)
    {
        speedSlow = speed - (fabs(location) / gOffect.maxOffect * maxOffectSpeed);
    }
#ifdef __DEBUG
    Serial.print("LinePatrolSpeed: ");
    Serial.println(speedSlow);
#endif /* __DEBUG */
    if (location == 0)
    {
        AIStarter_SmartBotSetMotor(MOTORR, speed);
        AIStarter_SmartBotSetMotor(MOTORL, speed);
    }
    else if (location < 0)
    {
        AIStarter_SmartBotSetMotor(MOTORR, speed);
        AIStarter_SmartBotSetMotor(MOTORL, speedSlow);
    }
    else if (location > 0)
    {
        AIStarter_SmartBotSetMotor(MOTORR, speedSlow);
        AIStarter_SmartBotSetMotor(MOTORL, speed);
    }
}




